use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- DEV-81788
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[SAT].[VX_sp_PublishQuestionnaireVersion]'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE [SAT].[VX_sp_PublishQuestionnaireVersion]
'

declare @ClientPayload02 nvarchar(max) = N'
CREATE PROCEDURE [SAT].[VX_sp_PublishQuestionnaireVersion]
 @iQuestionnaireId int,
 @iVersion int = 0,
 @iUserId int = 0,
 @errorFlags int output
AS
BEGIN

 SET @errorFlags = 0;
 SET NOCOUNT ON;
    --
    -- Declare tables that will store all the ids to copy
    --
    CREATE TABLE #tblQuestionnaireVersions ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblChoices ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlocks ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogicConditions ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionsRandomizations ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlockItems ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblVariables ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblChoiceSettings ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionSettings ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionActions ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSurveyOptions ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionnaireLanguages ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblChoiceLists ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblShortcuts ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlocksRandomizations ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblThemes ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblThemeElementProperties ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionActionProperties ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblVariableSettings ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlockItems_Question ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionShortText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionTitle ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionnaireMessageText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_QuestionnaireTerminationText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_ChoiceText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_ShortcutButtonText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_TranslatableQuestionSetting ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionActions_QuestionPreLoadAction ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblQuestionActions_QuestionPostAnswerAction ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_ThemeText ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_QuestionAskLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_SkipQuestionLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_BlockSkipLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_QuestionSettingSkipLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_VariableSkipLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_ChoiceSkipLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_ChoiceDisplayLogic ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_TranslatableVariableSetting ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblSkipLogics_QuestionActionExecutionCondition ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblLocalizableTexts_TranslatableChoiceSetting ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlockItems_PageBreak ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblBlockItems_LibraryQuestion ( [Id] int, PRIMARY KEY ([Id]) );
    CREATE TABLE #tblThemes_LibraryTheme ( [Id] int, PRIMARY KEY ([Id]) );
    
    --
    -- Retrieves ids
    --
    
    DECLARE @iItemCount bigint
    SET @iItemCount = 1;
    
      
    -- Set the next version for the questionnaire. This will be the published version
    DECLARE @iCurrentVersion int
    DECLARE @iNextVersion int
    DECLARE @iContextId int
      
    IF @iVersion = 0 
    BEGIN
     SET @iCurrentVersion = 0; -- Publishing from version 0
     SELECT @iNextVersion = (ISNULL(MAX([Version]), 0) + 1) FROM [SAT].[QuestionnaireVersions] WHERE [Id] = @iQuestionnaireId;
    END
    ELSE
    BEGIN
     SET @iCurrentVersion = @iVersion;   -- Publishing provided version 
     SET @iNextVersion = 0;    -- Setting the edit version
    END
    
    SELECT @iContextId = [ContextId] FROM [SAT].[Questionnaires] WHERE [Id] = @iQuestionnaireId;
   
 INSERT INTO #tblQuestionnaireVersions ([Id]) VALUES (@iQuestionnaireId);
 SET @iItemCount = 1;


 INSERT INTO #tblQuestionnaireLanguages ([Id]) SELECT [Id] FROM [SAT].QuestionnaireLanguages ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblQuestionnaireLanguages tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblSurveyOptions
 INSERT INTO #tblSurveyOptions ([Id]) SELECT [Id] FROM [SAT].SurveyOptions ins WHERE [Version] = @iCurrentVersion AND [Id] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblSurveyOptions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblBlocks
 INSERT INTO #tblBlocks ([Id]) SELECT [Id] FROM [SAT].Blocks ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblBlocks tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblBlockItems
 INSERT INTO #tblBlockItems ([Id]) SELECT [Id] FROM [SAT].BlockItems ins WHERE [Version] = @iCurrentVersion AND [BlockId] IN (SELECT [Id] FROM #tblBlocks ) AND NOT EXISTS (SELECT NULL FROM #tblBlockItems tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblBlockItems_Question
 INSERT INTO #tblBlockItems_Question ([Id]) SELECT [Id] FROM [SAT].BlockItems_Question ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems ) AND NOT EXISTS (SELECT NULL FROM #tblBlockItems_Question tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblBlockItems_PageBreak ([Id]) SELECT [Id] FROM [SAT].BlockItems_PageBreak ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems ) AND NOT EXISTS (SELECT NULL FROM #tblBlockItems_PageBreak tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblBlockItems_LibraryQuestion ([Id]) SELECT [Id] FROM [SAT].BlockItems_LibraryQuestion ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblBlockItems_LibraryQuestion tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 --#tblChoiceLists
 INSERT INTO #tblChoiceLists ([Id]) SELECT [Id] FROM [SAT].ChoiceLists ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireVersionId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblChoiceLists tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 --#tblChoices
 INSERT INTO #tblChoices ([Id]) SELECT [Id] FROM [SAT].Choices ins WHERE [Version] = @iCurrentVersion AND [ChoiceListId] IN (SELECT [Id] FROM #tblChoiceLists ) AND NOT EXISTS (SELECT NULL FROM #tblChoices tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblVariables
 INSERT INTO #tblVariables ([Id]) SELECT [Id] FROM [SAT].Variables ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblVariables tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 --#tblQuestionActions
 INSERT INTO #tblQuestionActions_QuestionPreLoadAction ([Id]) SELECT [Id] FROM [SAT].QuestionActions_QuestionPreLoadAction ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActions_QuestionPreLoadAction tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblQuestionActions_QuestionPostAnswerAction ([Id]) SELECT [Id] FROM [SAT].QuestionActions_QuestionPostAnswerAction ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActions_QuestionPostAnswerAction tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblQuestionActions ([Id]) SELECT DISTINCT [Id] FROM [SAT].QuestionActions_QuestionPreLoadAction ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions_QuestionPreLoadAction ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblQuestionActions ([Id]) SELECT DISTINCT [Id] FROM [SAT].QuestionActions_QuestionPostAnswerAction ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions_QuestionPostAnswerAction ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblSkipLogics
 INSERT INTO #tblSkipLogics ([Id]) SELECT [Id] FROM [SAT].SkipLogics ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogicConditions ([Id]) SELECT [Id] FROM [SAT].SkipLogicConditions ins WHERE [Version] = @iCurrentVersion AND [VariableToEvaluateId] IN (SELECT [Id] FROM #tblVariables ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogicConditions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogicConditions ([Id]) SELECT [Id] FROM [SAT].SkipLogicConditions ins WHERE [Version] = @iCurrentVersion AND [ShortcutId] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogicConditions tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblQuestionsRandomizations
 INSERT INTO #tblQuestionsRandomizations ([Id]) SELECT [Id] FROM [SAT].QuestionsRandomizations ins WHERE [Version] = @iCurrentVersion AND [BlockId] IN (SELECT [Id] FROM #tblBlocks ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionsRandomizations tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblChoiceSettings ([Id]) SELECT [Id] FROM [SAT].ChoiceSettings ins WHERE [Version] = @iCurrentVersion AND [ChoiceId] IN (SELECT [Id] FROM #tblChoices ) AND NOT EXISTS (SELECT NULL FROM #tblChoiceSettings tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblSkipLogics_QuestionSettingSkipLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_QuestionSettingSkipLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_QuestionSettingSkipLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblQuestionSettings ([Id]) SELECT [Id] FROM [SAT].QuestionSettings ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionSettings tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblQuestionActionProperties ([Id]) SELECT [Id] FROM [SAT].QuestionActionProperties ins WHERE [Version] = @iCurrentVersion AND [QuestionActionId] IN (SELECT [Id] FROM #tblQuestionActions ) AND NOT EXISTS (SELECT NULL FROM #tblQuestionActionProperties tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblVariableSettings ([Id]) SELECT [Id] FROM [SAT].VariableSettings ins WHERE [Version] = @iCurrentVersion AND [VariableId] IN (SELECT [Id] FROM #tblVariables ) AND NOT EXISTS (SELECT NULL FROM #tblVariableSettings tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_QuestionShortText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionShortText ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionShortText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionShortText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionShortText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_QuestionText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionText ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

    INSERT INTO #tblLocalizableTexts_QuestionTitle ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionTitle ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionTitle tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionTitle ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionTitle ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_QuestionnaireMessageText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionnaireMessageText ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] IN (SELECT [Id] FROM #tblQuestionnaireVersions ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionnaireMessageText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionnaireMessageText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionnaireMessageText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_QuestionnaireTerminationText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_QuestionnaireTerminationText ins WHERE [Version] = @iCurrentVersion AND [QuestionnaireId] = @iQuestionnaireId AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_QuestionnaireTerminationText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_QuestionnaireTerminationText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionnaireTerminationText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_ChoiceText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_ChoiceText ins WHERE [Version] = @iCurrentVersion AND [ChoiceId] IN (SELECT [Id] FROM #tblChoices ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_ChoiceText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_ChoiceText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ChoiceText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_TranslatableQuestionSetting ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_TranslatableQuestionSetting ins WHERE [Version] = @iCurrentVersion AND [QuestionId] IN (SELECT [Id] FROM #tblBlockItems_Question ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_TranslatableQuestionSetting tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_TranslatableQuestionSetting ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableQuestionSetting ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblSkipLogics_QuestionAskLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_QuestionAskLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_QuestionAskLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogics_SkipQuestionLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_SkipQuestionLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_SkipQuestionLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogics_BlockSkipLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_BlockSkipLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_BlockSkipLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT


 INSERT INTO #tblSkipLogics_VariableSkipLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_VariableSkipLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_VariableSkipLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogics_ChoiceSkipLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_ChoiceSkipLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_ChoiceSkipLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblSkipLogics_ChoiceDisplayLogic ([Id]) SELECT [Id] FROM [SAT].SkipLogics_ChoiceDisplayLogic ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_ChoiceDisplayLogic tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT


 INSERT INTO #tblLocalizableTexts_TranslatableVariableSetting ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_TranslatableVariableSetting ins WHERE [Version] = @iCurrentVersion AND [VariableId] IN (SELECT [Id] FROM #tblVariables ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_TranslatableVariableSetting tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_TranslatableVariableSetting ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableVariableSetting ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblSkipLogics_QuestionActionExecutionCondition ([Id]) SELECT [Id] FROM [SAT].SkipLogics_QuestionActionExecutionCondition ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics ) AND NOT EXISTS (SELECT NULL FROM #tblSkipLogics_QuestionActionExecutionCondition tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_TranslatableChoiceSetting ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_TranslatableChoiceSetting ins WHERE [Version] = @iCurrentVersion AND [ChoiceId] IN (SELECT [Id] FROM #tblChoices ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_TranslatableChoiceSetting tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_TranslatableChoiceSetting ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableChoiceSetting ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblShortcuts
 INSERT INTO #tblShortcuts ([Id]) SELECT [Id] FROM [SAT].Shortcuts ins WHERE [Version] = @iCurrentVersion AND [BlockId] IN (SELECT [Id] FROM #tblBlocks ) AND NOT EXISTS (SELECT NULL FROM #tblShortcuts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblShortcuts ([Id]) SELECT [Id] FROM [SAT].Shortcuts ins WHERE [Version] = @iCurrentVersion AND [SurveyOptionsId] IN (SELECT [Id] FROM #tblSurveyOptions ) AND NOT EXISTS (SELECT NULL FROM #tblShortcuts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblShortcuts ([Id]) SELECT DISTINCT [ShortcutId] FROM [SAT].LocalizableTexts_ShortcutButtonText ins WHERE [ShortcutId] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ShortcutButtonText ) AND NOT EXISTS (SELECT NULL FROM #tblShortcuts tbl WHERE ins.[ShortcutId] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 -- #tblBlocksRandomizations
 INSERT INTO #tblBlocksRandomizations ([Id]) SELECT [Id] FROM [SAT].BlocksRandomizations ins WHERE [Version] = @iCurrentVersion AND [SurveyOptionsId] IN (SELECT [Id] FROM #tblSurveyOptions ) AND NOT EXISTS (SELECT NULL FROM #tblBlocksRandomizations tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT


 INSERT INTO #tblLocalizableTexts_ShortcutButtonText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_ShortcutButtonText ins WHERE [Version] = @iCurrentVersion AND [ShortcutId] IN (SELECT [Id] FROM #tblShortcuts ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_ShortcutButtonText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_ShortcutButtonText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ShortcutButtonText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT


 -- #tblThemes
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [Theme_Id] FROM [SAT].Blocks ins WHERE [Theme_Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlocks ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[Theme_Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [Theme_Id] FROM [SAT].QuestionnaireVersions ins WHERE [Theme_Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionnaireVersions ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[Theme_Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [ThemeId] FROM [SAT].ThemeElementProperties ins WHERE [ThemeId] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemeElementProperties ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[ThemeId] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [ThemeId] FROM [SAT].LocalizableTexts_ThemeText ins WHERE [ThemeId] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ThemeText ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[ThemeId] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblThemes ([Id]) SELECT DISTINCT [Id] FROM [SAT].Themes_LibraryTheme ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemes_LibraryTheme ) AND NOT EXISTS (SELECT NULL FROM #tblThemes tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblThemeElementProperties ([Id]) SELECT [Id] FROM [SAT].ThemeElementProperties ins WHERE [Version] = @iCurrentVersion AND [ThemeId] IN (SELECT [Id] FROM #tblThemes ) AND NOT EXISTS (SELECT NULL FROM #tblThemeElementProperties tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblThemes_LibraryTheme ([Id]) SELECT [Id] FROM [SAT].Themes_LibraryTheme ins WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemes ) AND NOT EXISTS (SELECT NULL FROM #tblThemes_LibraryTheme tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

 INSERT INTO #tblLocalizableTexts_ThemeText ([Id]) SELECT [Id] FROM [SAT].LocalizableTexts_ThemeText ins WHERE [Version] = @iCurrentVersion AND [ThemeId] IN (SELECT [Id] FROM #tblThemes ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts_ThemeText tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT
 INSERT INTO #tblLocalizableTexts ([Id]) SELECT DISTINCT [Id] FROM [SAT].LocalizableTexts_ThemeText ins WHERE [Id] IS NOT NULL AND [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ThemeText ) AND NOT EXISTS (SELECT NULL FROM #tblLocalizableTexts tbl WHERE ins.[Id] = tbl.[Id])
 SET @iItemCount = @iItemCount + @@ROWCOUNT

    IF (SELECT COUNT(*) FROM #tblQuestionnaireVersions) > 1 BEGIN
     SET @errorFlags = 0x01
    END
     

 SET IDENTITY_INSERT [SAT].[Themes] ON; 
   INSERT INTO [SAT].[Themes] ([Id], [Version], [ThemeCategoryId], [Name], [PageHeaderVisible], [PageFooterVisible], [PageTitleVisible], [ProgressBarVisible], [ProgressBarLocationType], [ProgressBarShowPercentage], [ProgressBarShowLabel], [QuestionNameVisible], [QuestionLabelVisible], [BackButtonVisible], [BackButtonDisplayPositionType], [BackButtonType], [NextButtonVisible], [NextButtonDisplayPositionType], [NextButtonType], [QuitButtonVisible], [QuitButtonDisplayPositionType], [QuitButtonType], [RadioButtonType], [CheckBoxButtonType], [SurveyShortcutVisible], [SurveyShortcutLocationType], [QuestionBgSameAsBlock], [QuestionBlockBgSameAsPage], [HEAD], [CustomCSS], [CustomJavascript], [LastModifiedBy], [LastModificationDate], [CreatedBy], [CreationDate], [LanguageSelectorVisible], [LanguageSelectorLocationType], [LanguageSelectorShowLabel], [LanguageSelectorType], [MobileUseStandardButtons], [CenterQuestions], [ClearButtonVisible], [ClearButtonDisplayPositionType], [ClearButtonType], [TerminateButtonVisible], [TerminateButtonDisplayPositionType], [TerminateButtonType], [TooltipsVisible], [UsePageHeaderMobile], [UsePageFooterMobile], [PrintResponsesButtonVisible], [PrintResponsesButtonLocationType], [SettingsJson], [EnableBacklink]) 
                 SELECT [Id], @iNextVersion, [ThemeCategoryId], [Name], [PageHeaderVisible], [PageFooterVisible], [PageTitleVisible], [ProgressBarVisible], [ProgressBarLocationType], [ProgressBarShowPercentage], [ProgressBarShowLabel], [QuestionNameVisible], [QuestionLabelVisible], [BackButtonVisible], [BackButtonDisplayPositionType], [BackButtonType], [NextButtonVisible], [NextButtonDisplayPositionType], [NextButtonType], [QuitButtonVisible], [QuitButtonDisplayPositionType], [QuitButtonType], [RadioButtonType], [CheckBoxButtonType], [SurveyShortcutVisible], [SurveyShortcutLocationType], [QuestionBgSameAsBlock], [QuestionBlockBgSameAsPage], [HEAD], [CustomCSS], [CustomJavascript], [LastModifiedBy], [LastModificationDate], [CreatedBy], [CreationDate], [LanguageSelectorVisible], [LanguageSelectorLocationType], [LanguageSelectorShowLabel], [LanguageSelectorType], [MobileUseStandardButtons], [CenterQuestions], [ClearButtonVisible], [ClearButtonDisplayPositionType], [ClearButtonType], [TerminateButtonVisible], [TerminateButtonDisplayPositionType], [TerminateButtonType], [TooltipsVisible], [UsePageHeaderMobile], [UsePageFooterMobile], [PrintResponsesButtonVisible], [PrintResponsesButtonLocationType], [SettingsJson], [EnableBacklink]
            FROM [SAT].[Themes] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemes) ;
    SET IDENTITY_INSERT [SAT].[Themes] OFF; 
            
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
 
    INSERT INTO [SAT].[QuestionnaireVersions] ([Id], [Version], [CreationDate], [CreatedBy], [LastModificationDate], [LastModifiedBy], [PublishedDate], [PublishedBy], [Theme_Id], [Theme_Version]) 
            SELECT [Id], @iNextVersion, [CreationDate], [CreatedBy], [LastModificationDate], [LastModifiedBy], [PublishedDate], [PublishedBy], [Theme_Id], (CASE WHEN [Theme_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[QuestionnaireVersions] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionnaireVersions) 
            
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[QuestionnaireLanguages] ON; 
    INSERT INTO [SAT].[QuestionnaireLanguages] ([Id], [Version], [Language], [QuestionnaireId]) 
            SELECT [Id], @iNextVersion, [Language], [QuestionnaireId] 
            FROM [SAT].[QuestionnaireLanguages] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionnaireLanguages) 
    SET IDENTITY_INSERT [SAT].[QuestionnaireLanguages] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[LocalizableTexts] ON; 
    INSERT INTO [SAT].[LocalizableTexts] ([Id], [Version], [Language], [Text]) 
            SELECT [Id], @iNextVersion, [Language], [Text] 
            FROM [SAT].[LocalizableTexts] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts) ;
    SET IDENTITY_INSERT [SAT].[LocalizableTexts] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

 SET IDENTITY_INSERT [SAT].[Blocks] ON; 
      INSERT INTO [SAT].[Blocks] ([Id], [Version], [Name], [Description], [EnableLooping], [MaxLoopSize], [UseDefaultTheme], [DisplayShortcuts], [AutoPageBreakAfterQuestion], [AutoAdvance], [QuestionnaireId], [Position], [IsSection], [Theme_Id], [Theme_Version]) 
                 SELECT [Id], @iNextVersion, [Name], [Description], [EnableLooping], [MaxLoopSize], [UseDefaultTheme], [DisplayShortcuts], [AutoPageBreakAfterQuestion], [AutoAdvance], [QuestionnaireId], [Position], [IsSection], [Theme_Id], (CASE WHEN [Theme_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[Blocks] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlocks) 
    SET IDENTITY_INSERT [SAT].[Blocks] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[BlockItems] ON; 
    INSERT INTO [SAT].[BlockItems] ([Id], [Version], [BlockId], [Position]) 
            SELECT [Id], @iNextVersion, [BlockId], [Position] 
            FROM [SAT].[BlockItems] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems) 
    SET IDENTITY_INSERT [SAT].[BlockItems] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[BlockItems_Question] ([Name], [Active], [AnswerRequired], [QuestionCategoryId], [CreationDate], [CreatedBy], [LastModificationDate], [LastModifiedBy], [Id], [Version], [Type_Id]) 
            SELECT [Name], [Active], [AnswerRequired], [QuestionCategoryId], [CreationDate], [CreatedBy], [LastModificationDate], [LastModifiedBy], [Id], @iNextVersion, [Type_Id] 
            FROM [SAT].[BlockItems_Question] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems_Question) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[BlockItems_PageBreak] ([Id], [Version]) 
            SELECT [Id], @iNextVersion 
            FROM [SAT].[BlockItems_PageBreak] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems_PageBreak) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[BlockItems_LibraryQuestion] ([ContextId], [Id], [Version]) 
            SELECT [ContextId], [Id], @iNextVersion 
            FROM [SAT].[BlockItems_LibraryQuestion] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlockItems_LibraryQuestion) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    SET IDENTITY_INSERT [SAT].[ChoiceLists] ON; 
    INSERT INTO [SAT].[ChoiceLists] ([Id], [Version], [MaxChoicesCodeLength], [QuestionnaireVersionId], [CompiledJSON]) 
            SELECT [Id], @iNextVersion, [MaxChoicesCodeLength], [QuestionnaireVersionId], [CompiledJSON] 
            FROM [SAT].[ChoiceLists] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblChoiceLists) 
    SET IDENTITY_INSERT [SAT].[ChoiceLists] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    SET IDENTITY_INSERT [SAT].[Choices] ON; 
    INSERT INTO [SAT].[Choices] ([Id], [Version], [QuestionId], [ChoiceListId], [Available], [Exclusive], [Fixed], [Default], [OpenEndType], [OpenEndHeight], [OpenEndWidth], [OpenEndMaxLength], [OpenEndMinLength], [OpenEndDisplayWhenSelected], [Visible], [Value], [Position], [ParentValue], [SkipToQuestion_Id], [SkipToQuestion_Version], [EnforceOpenEnd], [OpenEndLines], [OpenEndSize]) 
                 SELECT [Id], @iNextVersion, [QuestionId], [ChoiceListId], [Available], [Exclusive], [Fixed], [Default], [OpenEndType], [OpenEndHeight], [OpenEndWidth], [OpenEndMaxLength], [OpenEndMinLength], [OpenEndDisplayWhenSelected], [Visible], [Value], [Position], [ParentValue], [SkipToQuestion_Id], (CASE WHEN [SkipToQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [EnforceOpenEnd], [OpenEndLines], [OpenEndSize]
            FROM [SAT].[Choices] ins 
            WHERE  [Id] IN (SELECT [Id] FROM #tblChoices) AND [Version] = @iCurrentVersion 
    SET IDENTITY_INSERT [SAT].[Choices] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[Variables] ON; 
      INSERT INTO [SAT].[Variables] ([Id], [Version], [Name], [QuestionId], [VariableType], [HasOpenEnd], [MaxMention], [DataType], [Position], [ChoiceListId], [ChoiceListVersion]) 
                 SELECT [Id], @iNextVersion, [Name], [QuestionId], [VariableType], [HasOpenEnd], [MaxMention], [DataType], [Position], [ChoiceListId], (CASE WHEN [ChoiceListId] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[Variables] ins 
            WHERE [Id] IN (SELECT [Id] FROM #tblVariables)  AND [Version] = @iCurrentVersion
    SET IDENTITY_INSERT [SAT].[Variables] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
 
 SET IDENTITY_INSERT [SAT].[QuestionActions] ON; 
    INSERT INTO [SAT].[QuestionActions] ([Id], [Version], [Position], [ActionType], [Condition]) 
            SELECT [Id], @iNextVersion, [Position], [ActionType], [Condition] 
            FROM [SAT].[QuestionActions] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions) ;
    SET IDENTITY_INSERT [SAT].[QuestionActions] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[QuestionActions_QuestionPreLoadAction] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[QuestionActions_QuestionPreLoadAction] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions_QuestionPreLoadAction) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[QuestionActions_QuestionPostAnswerAction] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[QuestionActions_QuestionPostAnswerAction] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActions_QuestionPostAnswerAction) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
         
 SET IDENTITY_INSERT [SAT].[SkipLogics] ON; 
    INSERT INTO [SAT].[SkipLogics] ([Id], [Version], [Syntax], [ConditionType], [SyntaxType], [QuestionnaireId]) 
            SELECT [Id], @iNextVersion, [Syntax], [ConditionType], [SyntaxType], [QuestionnaireId] 
            FROM [SAT].[SkipLogics] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics) 
            AND (ins.[QuestionnaireId] IS NULL OR EXISTS (SELECT NULL FROM [SAT].[QuestionnaireVersions] ref WHERE ref.[Id] = ins.[QuestionnaireId] AND ref.[Version] = @iNextVersion));
    SET IDENTITY_INSERT [SAT].[SkipLogics] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    SET IDENTITY_INSERT [SAT].[SkipLogicConditions] ON; 
    INSERT INTO [SAT].[SkipLogicConditions] ([Id], [Version], [OperatorType], [Value], [ShortcutId], [VariableToEvaluateId]) 
            SELECT [Id], @iNextVersion, [OperatorType], [Value], [ShortcutId], [VariableToEvaluateId] 
            FROM [SAT].[SkipLogicConditions] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogicConditions) 
    SET IDENTITY_INSERT [SAT].[SkipLogicConditions] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    SET IDENTITY_INSERT [SAT].[QuestionsRandomizations] ON; 
    INSERT INTO [SAT].[QuestionsRandomizations] ([Id], [Version], [RandomizationPatternType], [StartQuestionId], [EndQuestionId], [BlockId], [Position], [SynchronizeWithId], [GroupCount]) 
            SELECT [Id], @iNextVersion, [RandomizationPatternType], [StartQuestionId], [EndQuestionId], [BlockId], [Position], [SynchronizeWithId], [GroupCount] 
            FROM [SAT].[QuestionsRandomizations] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionsRandomizations) 
    SET IDENTITY_INSERT [SAT].[QuestionsRandomizations] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
     
    SET IDENTITY_INSERT [SAT].[ChoiceSettings] ON; 
    INSERT INTO [SAT].[ChoiceSettings] ([Id], [Version], [ChoiceId], [Name], [Value]) 
            SELECT [Id], @iNextVersion, [ChoiceId], [Name], [Value] 
            FROM [SAT].[ChoiceSettings] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblChoiceSettings) 
    SET IDENTITY_INSERT [SAT].[ChoiceSettings] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_QuestionSettingSkipLogic] ([QuestionId], [Id], [Version])
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[SkipLogics_QuestionSettingSkipLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_QuestionSettingSkipLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    SET IDENTITY_INSERT [SAT].[QuestionSettings] ON; 
    INSERT INTO [SAT].[QuestionSettings] ([Id], [Version], [QuestionId], [Value], [QuestionSettingDefinitionId], [SkipLogic_Id], [SkipLogic_Version]) 
            SELECT [Id], @iNextVersion, [QuestionId], [Value], [QuestionSettingDefinitionId], [SkipLogic_Id], (CASE WHEN [SkipLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[QuestionSettings] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionSettings) 
    SET IDENTITY_INSERT [SAT].[QuestionSettings] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
    
    SET IDENTITY_INSERT [SAT].[ThemeElementProperties] ON; 
    INSERT INTO [SAT].[ThemeElementProperties] ([Id], [Version], [ThemeElementType], [ThemeId], [Name], [Value]) 
            SELECT [Id], @iNextVersion, [ThemeElementType], [ThemeId], [Name], [Value] 
            FROM [SAT].[ThemeElementProperties] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemeElementProperties) 
    SET IDENTITY_INSERT [SAT].[ThemeElementProperties] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    SET IDENTITY_INSERT [SAT].[QuestionActionProperties] ON; 
    INSERT INTO [SAT].[QuestionActionProperties] ([Id], [Version], [Name], [Value], [QuestionActionId]) 
            SELECT [Id], @iNextVersion, [Name], [Value], [QuestionActionId] 
            FROM [SAT].[QuestionActionProperties] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblQuestionActionProperties) 
    SET IDENTITY_INSERT [SAT].[QuestionActionProperties] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    SET IDENTITY_INSERT [SAT].[VariableSettings] ON; 
    INSERT INTO [SAT].[VariableSettings] ([Id], [Version], [Value], [VariableId], [VariableSettingDefinitionId]) 
            SELECT [Id], @iNextVersion, [Value], [VariableId], [VariableSettingDefinitionId] 
            FROM [SAT].[VariableSettings] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblVariableSettings) 
    SET IDENTITY_INSERT [SAT].[VariableSettings] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
        
    INSERT INTO [SAT].[LocalizableTexts_QuestionShortText] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionShortText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionShortText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_QuestionText] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[LocalizableTexts_QuestionTitle] ([QuestionId], [Id], [Version]) 
            SELECT [QuestionId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionTitle] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionTitle) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_QuestionnaireMessageText] ([ErrorMessageId], [QuestionnaireId], [Id], [Version]) 
            SELECT [ErrorMessageId], [QuestionnaireId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionnaireMessageText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionnaireMessageText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_QuestionnaireTerminationText] ([QuestionnaireId], [Id], [Version]) 
            SELECT [QuestionnaireId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_QuestionnaireTerminationText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_QuestionnaireTerminationText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_ChoiceText] ([ChoiceId], [Id], [Version]) 
            SELECT [ChoiceId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_ChoiceText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ChoiceText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
       
    INSERT INTO [SAT].[LocalizableTexts_ThemeText] ([ThemeDefaultTextId], [ThemeId], [Id], [Version]) 
            SELECT [ThemeDefaultTextId], [ThemeId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_ThemeText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ThemeText) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[SkipLogics_QuestionAskLogic] ([Id], [Version], [QuestionQuestionAskLogic_QuestionAskLogic_Id], [QuestionQuestionAskLogic_QuestionAskLogic_Version]) 
            SELECT [Id], @iNextVersion, [QuestionQuestionAskLogic_QuestionAskLogic_Id], (CASE WHEN [QuestionQuestionAskLogic_QuestionAskLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_QuestionAskLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_QuestionAskLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_SkipQuestionLogic] ([Id], [Version], [QuestionQuestionSkipLogic_QuestionSkipLogic_Id], [QuestionQuestionSkipLogic_QuestionSkipLogic_Version]) 
            SELECT [Id], @iNextVersion, [QuestionQuestionSkipLogic_QuestionSkipLogic_Id], (CASE WHEN [QuestionQuestionSkipLogic_QuestionSkipLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_SkipQuestionLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_SkipQuestionLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[LocalizableTexts_TranslatableQuestionSetting] ([QuestionId], [QuestionSettingDefinitionId], [Id], [Version], [SkipLogic_Id], [SkipLogic_Version]) 
            SELECT [QuestionId], [QuestionSettingDefinitionId], [Id], @iNextVersion, [SkipLogic_Id], (CASE WHEN [SkipLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[LocalizableTexts_TranslatableQuestionSetting] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableQuestionSetting) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_BlockSkipLogic] ([Id], [Version], [BlockBlockSkipLogic_BlockSkipLogic_Id], [BlockBlockSkipLogic_BlockSkipLogic_Version]) 
            SELECT [Id], @iNextVersion, [BlockBlockSkipLogic_BlockSkipLogic_Id], (CASE WHEN [BlockBlockSkipLogic_BlockSkipLogic_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_BlockSkipLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_BlockSkipLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
            
    INSERT INTO [SAT].[SkipLogics_VariableSkipLogic] ([Id], [Version], [Variable_Id], [Variable_Version]) 
            SELECT [Id], @iNextVersion, [Variable_Id], (CASE WHEN [Variable_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_VariableSkipLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_VariableSkipLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    INSERT INTO [SAT].[SkipLogics_ChoiceSkipLogic] ([Id], [Version], [Choice_Id], [Choice_Version]) 
            SELECT [Id], @iNextVersion, [Choice_Id], (CASE WHEN [Choice_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_ChoiceSkipLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_ChoiceSkipLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_ChoiceDisplayLogic] ([Id], [Version], [Choice_Id], [Choice_Version]) 
            SELECT [Id], @iNextVersion, [Choice_Id], (CASE WHEN [Choice_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_ChoiceDisplayLogic] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_ChoiceDisplayLogic) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_TranslatableVariableSetting] ([VariableId], [VariableSettingDefinitionId], [Id], [Version])
            SELECT [VariableId], [VariableSettingDefinitionId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_TranslatableVariableSetting] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableVariableSetting) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[SkipLogics_QuestionActionExecutionCondition] ([Id], [Version], [QuestionAction_Id], [QuestionAction_Version]) 
            SELECT [Id], @iNextVersion, [QuestionAction_Id], (CASE WHEN [QuestionAction_Id] is NULL THEN NULL ELSE @iNextVersion END) 
            FROM [SAT].[SkipLogics_QuestionActionExecutionCondition] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSkipLogics_QuestionActionExecutionCondition) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_TranslatableChoiceSetting] ([Name], [ChoiceId], [Id], [Version]) 
            SELECT [Name], [ChoiceId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_TranslatableChoiceSetting] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_TranslatableChoiceSetting) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[Themes_LibraryTheme] ([ContextId], [Id], [Version]) 
            SELECT [ContextId], [Id], @iNextVersion 
            FROM [SAT].[Themes_LibraryTheme] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblThemes_LibraryTheme) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
   INSERT INTO [SAT].[SurveyOptions] ([Id], [Version], [AutomaticCleaning], [AutoSubmitAnwers], [InputRequired], [PageOptionType], [SurveyTerminationOptionType], [SurveyTerminationValue], [DefaultLanguage], [DisplayErrorAsPopUps], [LastModifiedBy], [LastModificationDate], [DisableSmartPhoneMobileSupport], [DisableTabletMobileSupport], [DisableTabletGridMobileRendering], [DisableSmartPhoneGridMobileRendering], [UnknownDeviceHandlingType], [UnsupportedDeviceHandlingType], [UnknownDeviceRedirectURL], [UnsupportedDeviceRedirectURL], [CollectRespondentGeoLocation], [MobileDeviceHandlingType], [TabletDeviceHandlingType], [MobileDeviceRedirectURL], [TabletDeviceRedirectURL], [ExecuteAdvancedActionsOnResume], [Points], [QuitButtonType], [AutoSynchronizePanelData], [AutoSynchronizePanelDataExclusionFilter], [AllowCaseCreationOnMobileDevices], [CompletionQuestion_Id], [CompletionQuestion_Version], [StartQuestion_Id], [StartQuestion_Version], [ResumeCompletedQuestion_Id], [ResumeCompletedQuestion_Version], [ResumeNotCompletedQuestion_Id], [ResumeNotCompletedQuestion_Version], [ProgressionStartQuestion_Id], [ProgressionStartQuestion_Version], [ProgressionEndQuestion_Id], [ProgressionEndQuestion_Version], [QuitButtonBranchToQuestion_Id], [QuitButtonBranchToQuestion_Version], [ResponseChangeTrackingMode], [ResponseChangeTrackingVariables], [CleanCallingQuestionOnPreloadBranching], [SAMLAttribute], [CompletedTerminationAction], [CompletedRedirectUrl], [ScreenedOutTerminationAction], [ScreenedOutRedirectUrl], [InterruptedTerminationAction], [InterruptedRedirectUrl], [SurveyProviderVariableName], [SaveRespondentQuestionsDisplayOrder], [PIIVariables] ,[SurveyAutoAdvanceMode], [ViewResponsesExcludedVariables], [OpenEndAnalysisVariables], [SaveRespondentRandomizationPosition])
                 SELECT [Id], @iNextVersion, [AutomaticCleaning], [AutoSubmitAnwers], [InputRequired], [PageOptionType], [SurveyTerminationOptionType], [SurveyTerminationValue], [DefaultLanguage], [DisplayErrorAsPopUps], [LastModifiedBy], [LastModificationDate], [DisableSmartPhoneMobileSupport], [DisableTabletMobileSupport], [DisableTabletGridMobileRendering], [DisableSmartPhoneGridMobileRendering], [UnknownDeviceHandlingType], [UnsupportedDeviceHandlingType], [UnknownDeviceRedirectURL], [UnsupportedDeviceRedirectURL], [CollectRespondentGeoLocation], [MobileDeviceHandlingType], [TabletDeviceHandlingType], [MobileDeviceRedirectURL], [TabletDeviceRedirectURL], [ExecuteAdvancedActionsOnResume], [Points], [QuitButtonType], [AutoSynchronizePanelData], [AutoSynchronizePanelDataExclusionFilter], [AllowCaseCreationOnMobileDevices], [CompletionQuestion_Id], (CASE WHEN [CompletionQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [StartQuestion_Id], (CASE WHEN [StartQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ResumeCompletedQuestion_Id], (CASE WHEN [ResumeCompletedQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ResumeNotCompletedQuestion_Id], (CASE WHEN [ResumeNotCompletedQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ProgressionStartQuestion_Id], (CASE WHEN [ProgressionStartQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ProgressionEndQuestion_Id], (CASE WHEN [ProgressionEndQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [QuitButtonBranchToQuestion_Id], (CASE WHEN [QuitButtonBranchToQuestion_Id] is NULL THEN NULL ELSE @iNextVersion END), [ResponseChangeTrackingMode], [ResponseChangeTrackingVariables], [CleanCallingQuestionOnPreloadBranching], [SAMLAttribute], [CompletedTerminationAction], [CompletedRedirectUrl], [ScreenedOutTerminationAction], [ScreenedOutRedirectUrl], [InterruptedTerminationAction], [InterruptedRedirectUrl], [SurveyProviderVariableName], [SaveRespondentQuestionsDisplayOrder], [PIIVariables], [SurveyAutoAdvanceMode], [ViewResponsesExcludedVariables], [OpenEndAnalysisVariables], [SaveRespondentRandomizationPosition]
            FROM [SAT].[SurveyOptions] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblSurveyOptions) 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
 SET IDENTITY_INSERT [SAT].[Shortcuts] ON; 
    INSERT INTO [SAT].[Shortcuts] ([Id], [Version], [Position], [BlockId], [ExitToType], [SurveyOptionsId]) 
            SELECT [Id], @iNextVersion, [Position], [BlockId], [ExitToType], [SurveyOptionsId] 
            FROM [SAT].[Shortcuts] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblShortcuts) 
    SET IDENTITY_INSERT [SAT].[Shortcuts] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;

    SET IDENTITY_INSERT [SAT].[BlocksRandomizations] ON; 
    INSERT INTO [SAT].[BlocksRandomizations] ([Id], [Version], [RandomizationPatternType], [EndBlockId], [StartBlockId], [SurveyOptionsId], [Position], [SynchronizeWithId]) 
            SELECT [Id], @iNextVersion, [RandomizationPatternType], [EndBlockId], [StartBlockId], [SurveyOptionsId], [Position], [SynchronizeWithId] 
            FROM [SAT].[BlocksRandomizations] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblBlocksRandomizations) 
    SET IDENTITY_INSERT [SAT].[BlocksRandomizations] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
   
    INSERT INTO [SAT].[LocalizableTexts_ShortcutButtonText] ([ShortcutId], [Id], [Version]) 
            SELECT [ShortcutId], [Id], @iNextVersion 
            FROM [SAT].[LocalizableTexts_ShortcutButtonText] ins 
            WHERE [Version] = @iCurrentVersion AND [Id] IN (SELECT [Id] FROM #tblLocalizableTexts_ShortcutButtonText) 
    --SET IDENTITY_INSERT [SAT].[LocalizableTexts_ShortcutButtonText] OFF; 
    SET @iItemCount = @iItemCount - @@ROWCOUNT;
    
    DROP TABLE #tblQuestionnaireVersions;
    DROP TABLE #tblChoices;
    DROP TABLE #tblBlocks;
    DROP TABLE #tblSkipLogicConditions;
    DROP TABLE #tblQuestionsRandomizations;
    DROP TABLE #tblBlockItems;
    DROP TABLE #tblVariables;
    DROP TABLE #tblChoiceSettings;
    DROP TABLE #tblQuestionSettings;
    DROP TABLE #tblQuestionActions;
    DROP TABLE #tblSurveyOptions;
    DROP TABLE #tblQuestionnaireLanguages;
    DROP TABLE #tblLocalizableTexts;
    DROP TABLE #tblChoiceLists;
    DROP TABLE #tblShortcuts;
    DROP TABLE #tblSkipLogics;
    DROP TABLE #tblBlocksRandomizations;
    DROP TABLE #tblThemes;
    DROP TABLE #tblThemeElementProperties;
    DROP TABLE #tblQuestionActionProperties;
    DROP TABLE #tblVariableSettings;
    DROP TABLE #tblBlockItems_Question;
    DROP TABLE #tblLocalizableTexts_QuestionShortText;
    DROP TABLE #tblLocalizableTexts_QuestionText;
    DROP TABLE #tblLocalizableTexts_QuestionTitle;
    DROP TABLE #tblLocalizableTexts_QuestionnaireMessageText;
    DROP TABLE #tblLocalizableTexts_QuestionnaireTerminationText;
    DROP TABLE #tblLocalizableTexts_ChoiceText;
    DROP TABLE #tblLocalizableTexts_ShortcutButtonText;
    DROP TABLE #tblLocalizableTexts_TranslatableQuestionSetting;
    DROP TABLE #tblQuestionActions_QuestionPreLoadAction;
    DROP TABLE #tblQuestionActions_QuestionPostAnswerAction;
    DROP TABLE #tblLocalizableTexts_ThemeText;
    DROP TABLE #tblSkipLogics_QuestionAskLogic;
    DROP TABLE #tblSkipLogics_SkipQuestionLogic;
    DROP TABLE #tblSkipLogics_BlockSkipLogic;
    DROP TABLE #tblSkipLogics_QuestionSettingSkipLogic;
    DROP TABLE #tblSkipLogics_VariableSkipLogic;
    DROP TABLE #tblSkipLogics_ChoiceSkipLogic;
    DROP TABLE #tblSkipLogics_ChoiceDisplayLogic;
    DROP TABLE #tblLocalizableTexts_TranslatableVariableSetting;
    DROP TABLE #tblSkipLogics_QuestionActionExecutionCondition;
    DROP TABLE #tblLocalizableTexts_TranslatableChoiceSetting;
    DROP TABLE #tblBlockItems_PageBreak;
    DROP TABLE #tblBlockItems_LibraryQuestion;
    DROP TABLE #tblThemes_LibraryTheme;
    
    
    DECLARE @dt DATETIME = GETUTCDATE()
      
    -- For version 0 we dont copy back into the questionnaire question type styles since these are stored in question type style only
    IF @iNextVersion <> 0 
    BEGIN
     -- Copy the styles
     INSERT INTO [SAT].[QuestionnaireQuestionTypeStyles]
        ([QuestionnaireId], [Version], [Id], [Name], [LastModificationDate], [LastModifiedBy], [QuestionTypeId])   
      (SELECT @iQuestionnaireId, @iNextVersion, [Id], [Name], [LastModificationDate], [LastModifiedBy], [QuestionTypeId]
       FROM [QuestionTypeStyles]
       WHERE [ContextId] = @iContextId);
          
     -- Copy the style properties
     INSERT INTO [SAT].[QuestionnaireQuestionTypeStyleProperties]
         ([QuestionnaireId], [Version], [QuestionnaireQuestionTypeStyleId], [Id], [Name], [Value])   
      (SELECT @iQuestionnaireId, @iNextVersion, [QuestionTypeStyle_Id], [Id], [Name], [Value]
       FROM [QuestionTypeStyleProperties]
       WHERE [QuestionTypeStyle_ContextId] = @iContextId);
     
     UPDATE [SAT].[QuestionnaireVersions]
      SET CreatedBy      = @iUserId, CreationDate         = @dt, 
       PublishedBy    = @iUserId, PublishedDate        = @dt, 
       LastModifiedBy = @iUserId, LastModificationDate = @dt
      WHERE Id = @iQuestionnaireId AND Version = @iNextVersion;  
    END
    ELSE
    BEGIN
      DECLARE @publishedDate DATETIME 
      DECLARE @publishedVersion int
    
      SELECT @publishedDate = MAX(qv.[PublishedDate]) , @publishedVersion = MAX(qv.Version)
      FROM [SAT].[QuestionnaireVersions] AS qv 
      WHERE qv.[Id]=@iQuestionnaireId
    
      IF @iCurrentVersion = @publishedVersion 
      BEGIN
       SET @dt = @publishedDate
      END
    
      UPDATE [SAT].[Questionnaires]
         SET LastModifiedBy = @iUserId, LastModificationDate = @dt
         WHERE Id = @iQuestionnaireId; 
    
      UPDATE [SAT].[QuestionnaireVersions]
      SET LastModifiedBy = @iUserId, LastModificationDate = @dt, PublishedDate = NULL
      WHERE Id = @iQuestionnaireId AND Version = @iNextVersion; 
    
      UPDATE t
      SET LastModifiedBy = @iUserId, LastModificationDate = @dt
         FROM [SAT].[Themes] AS t
      INNER JOIN [SAT].[QuestionnaireVersions] AS qv ON qv.[Theme_Id]=t.[Id] 
         WHERE qv.Id = @iQuestionnaireId AND qv.Version = @iNextVersion AND t.Version = @iNextVersion; 
    END
END
'

declare @ClientPayload03 nvarchar(max) = N'
-- DEV-81788   66472
IF TYPE_ID(N''[dbo].[RespondentQuestionRandomizationList]'') IS NULL
BEGIN
	CREATE TYPE [dbo].[RespondentQuestionRandomizationList]
	AS TABLE
	(
		[QuestionId] INT NOT NULL,
		[Position] INT NOT NULL
	);
END
'

declare @ClientPayload04 nvarchar(max) = N'
IF TYPE_ID(N''[dbo].[RespondentVariableRandomizationList]'') IS NULL
BEGIN
	CREATE TYPE [dbo].[RespondentVariableRandomizationList]
	AS TABLE
	(
		[VariableName] NVARCHAR(255) NOT NULL,
		[Position] INT NOT NULL
	);
END
'

declare @ClientPayload05 nvarchar(max) = N'
IF NOT EXISTS (SELECT 1 FROM sys.columns WHERE [object_id] = OBJECT_ID(N''[SAT].[SurveyOptions]'') and [name] = N''SaveRespondentRandomizationPosition'')
BEGIN
    ALTER TABLE [SAT].[SurveyOptions]
    ADD [SaveRespondentRandomizationPosition] bit NOT NULL DEFAULT(0)
END
'

declare @ClientPayload06 nvarchar(max) = N'
-- DEV-81762  66491
IF TYPE_ID(N''[dbo].[LanguageList]'') IS NULL
BEGIN
	CREATE TYPE [dbo].[LanguageList]
	AS TABLE
	(
		[Language] NVARCHAR(10) NOT NULL
	);
END
'

declare @ClientPayload07 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[SAT].[VX_sp_GetChoices]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [SAT].[VX_sp_GetChoices]
'

declare @ClientPayload08 nvarchar(max) = N'
CREATE PROCEDURE [SAT].[VX_sp_GetChoices]
    @choiceListIds [dbo].[IdList] READONLY,
    @version INT
AS
BEGIN
    SELECT c.[Id],
           c.[Version],
           c.[QuestionId],
           c.[ChoiceListId],
           c.[Available],
           c.[Exclusive],
           c.[Fixed],
           c.[Default],
           c.[OpenEndType],
           c.[OpenEndHeight],
           c.[OpenEndWidth],
           c.[OpenEndMaxLength],
           c.[OpenEndDisplayWhenSelected],
           c.[OpenEndLines],
           c.[OpenEndSize],
           c.[Visible],
           c.[Value],
           c.[Position],
           c.[ParentValue],
           c.[OpenEndMinLength],
           c.[EnforceOpenEnd]
    FROM @choiceListIds cl
    INNER JOIN [Choices] c ON cl.[Id] = c.[ChoiceListId] AND c.[Version] = @version
    ORDER BY c.[ChoiceListId], c.[Position];
END
'

declare @ClientPayload09 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[SAT].[VX_sp_GetChoiceSettings]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [SAT].[VX_sp_GetChoiceSettings]
'

declare @ClientPayload10 nvarchar(max) = N'
CREATE PROCEDURE [SAT].[VX_sp_GetChoiceSettings]
    @choiceIds [dbo].[IdList] READONLY,
    @version INT
AS
BEGIN
    SELECT cs.[Id], cs.[Version], cs.[ChoiceId], cs.[Name], cs.[Value]
    FROM @choiceIds c
    INNER JOIN [ChoiceSettings] cs ON c.[Id] = cs.[ChoiceId] AND cs.[Version] = @version;
END
'

declare @ClientPayload11 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[SAT].[VX_sp_GetChoiceTexts]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [SAT].[VX_sp_GetChoiceTexts]
'

declare @ClientPayload12 nvarchar(max) = N'
CREATE PROCEDURE [SAT].[VX_sp_GetChoiceTexts]
    @choiceIds [dbo].[IdList] READONLY,
    @version INT,
    @languages [dbo].[LanguageList] READONLY
AS
BEGIN
    SELECT ct.[Id], ct.[Version], ct.[ChoiceId], lt.[Language], lt.[Text]
    FROM @choiceIds c
    INNER JOIN [LocalizableTexts_ChoiceText] ct ON c.[Id] = ct.[ChoiceId] AND ct.[Version] = @version
    INNER JOIN [LocalizableTexts] lt ON ct.[Id] = lt.[Id] AND ct.[Version] = lt.[Version]
    INNER JOIN @languages l ON lt.[Language] = l.[Language];
END
'

declare @ClientPayload13 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[SAT].[VX_sp_GetTranslatableChoiceSettings]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [SAT].[VX_sp_GetTranslatableChoiceSettings]
'

declare @ClientPayload14 nvarchar(max) = N'
CREATE PROCEDURE [SAT].[VX_sp_GetTranslatableChoiceSettings]
    @choiceIds [dbo].[IdList] READONLY,
    @version INT,
    @languages [dbo].[LanguageList] READONLY
AS
BEGIN
    SELECT tcs.[Id], tcs.[Version], tcs.[ChoiceId], tcs.[Name], lt.[Language], lt.[Text]
    FROM @choiceIds c
    INNER JOIN [LocalizableTexts_TranslatableChoiceSetting] tcs ON c.[Id] = tcs.[ChoiceId] AND tcs.[Version] = @version
    INNER JOIN [LocalizableTexts] lt ON tcs.[Id] = lt.[Id] AND tcs.[Version] = lt.[Version]
    INNER JOIN @languages l ON lt.[Language] = l.[Language];
END
'

declare @ClientPayload15 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[SAT].[VX_sp_GetChoiceSkipLogics]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [SAT].[VX_sp_GetChoiceSkipLogics]
'

declare @ClientPayload16 nvarchar(max) = N'
CREATE PROCEDURE [SAT].[VX_sp_GetChoiceSkipLogics]
    @choiceIds [dbo].[IdList] READONLY,
    @version INT
AS
BEGIN
    SELECT sl.[Id], sl.[Version], sl.[Syntax], sl.[ConditionType], sl.[SyntaxType], sl.[QuestionnaireId],
           slc.[Id] AS [ConditionId], slc.[OperatorType], slc.[Value], slc.[VariableToEvaluateId], v.[Name] AS [VariableToEvaluateName],
           csl.[Choice_Id] AS [ChoiceId], csl.[Choice_Version] AS [ChoiceVersion]
    FROM @choiceIds c
    INNER JOIN [SkipLogics_ChoiceSkipLogic] csl ON c.[Id] = csl.[Choice_Id] AND csl.[Choice_Version] = @version
    INNER JOIN [SkipLogics] sl ON csl.[Id] = sl.[Id] AND csl.[Version] = sl.[Version]
    LEFT JOIN [SkipLogicConditions] slc ON sl.[Id] = slc.[ShortcutId] AND sl.[Version] = slc.[Version]
    LEFT JOIN [Variables] v ON slc.[VariableToEvaluateId] = v.[Id] AND slc.[Version] = v.[Version]
    ORDER BY sl.[Id], slc.[Id];
END
'

declare @ClientPayload17 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''[SAT].[VX_sp_GetChoiceDisplayLogics]'') AND type IN (N''P'', N''PC''))
   DROP PROCEDURE [SAT].[VX_sp_GetChoiceDisplayLogics]
'

declare @ClientPayload18 nvarchar(max) = N'
CREATE PROCEDURE [SAT].[VX_sp_GetChoiceDisplayLogics]
    @choiceIds [dbo].[IdList] READONLY,
    @version INT
AS
BEGIN
    SELECT sl.[Id], sl.[Version], sl.[Syntax], sl.[ConditionType], sl.[SyntaxType], sl.[QuestionnaireId],
           slc.[Id] AS [ConditionId], slc.[OperatorType], slc.[Value], slc.[VariableToEvaluateId], v.[Name] AS [VariableToEvaluateName],
           csl.[Choice_Id] AS [ChoiceId], csl.[Choice_Version] AS [ChoiceVersion]
    FROM @choiceIds c
    INNER JOIN [SkipLogics_ChoiceDisplayLogic] csl ON c.[Id] = csl.[Choice_Id] AND csl.[Choice_Version] = @version
    INNER JOIN [SkipLogics] sl ON csl.[Id] = sl.[Id] AND csl.[Version] = sl.[Version]
    LEFT JOIN [SkipLogicConditions] slc ON sl.[Id] = slc.[ShortcutId] AND sl.[Version] = slc.[Version]
    LEFT JOIN [Variables] v ON slc.[VariableToEvaluateId] = v.[Id] AND slc.[Version] = v.[Version]
    ORDER BY sl.[Id], slc.[Id];
END
'

declare @SurveyPayload01 nvarchar(max) = N'
-- DEV-81788 66180
IF NOT EXISTS (SELECT 1 FROM sys.tables WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[RespondentBlockRandomization]''))
BEGIN
	CREATE TABLE #SURVEY SCHEMA#.[RespondentBlockRandomization]
	(		
		[RespondentId] INT NOT NULL,
		[BlockId] INT NOT NULL,
		[Matrix] INT NOT NULL,
		[Position] INT NOT NULL,
		CONSTRAINT [PK_RespondentBlockRandomization] PRIMARY KEY CLUSTERED ([RespondentId], [BlockId], [Matrix] ASC),
		CONSTRAINT [FK_RespondentBlockRandomization_Respondent] FOREIGN KEY([RespondentId]) REFERENCES #SURVEY SCHEMA#.[Respondent] ([ResRespondent]) ON DELETE CASCADE,	
	)
END
'

declare @SurveyPayload02 nvarchar(max) = N'
IF NOT EXISTS (SELECT 1 FROM sys.tables WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[RespondentQuestionRandomization]''))
BEGIN
	CREATE TABLE #SURVEY SCHEMA#.[RespondentQuestionRandomization]
	(		
		[RespondentId] INT NOT NULL,
		[QuestionId] INT NOT NULL,
		[Matrix] INT NOT NULL,
		[Position] INT NOT NULL,
		CONSTRAINT [PK_RespondentQuestionRandomization] PRIMARY KEY CLUSTERED ([RespondentId], [QuestionId], [Matrix] ASC),
		CONSTRAINT [FK_RespondentQuestionRandomization_Respondent] FOREIGN KEY([RespondentId]) REFERENCES #SURVEY SCHEMA#.[Respondent] ([ResRespondent]) ON DELETE CASCADE,	
	)
END
'

declare @SurveyPayload03 nvarchar(max) = N'
IF NOT EXISTS (SELECT 1 FROM sys.tables WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[RespondentVariableRandomization]''))
BEGIN
	CREATE TABLE #SURVEY SCHEMA#.[RespondentVariableRandomization]
	(		
		[RespondentId] INT NOT NULL,
		[VariableName] NVARCHAR(255) NOT NULL,
		[Matrix] INT NOT NULL,
		[Position] INT NOT NULL,
		CONSTRAINT [PK_RespondentVariableRandomization] PRIMARY KEY CLUSTERED ([RespondentId], [VariableName], [Matrix] ASC),
		CONSTRAINT [FK_RespondentVariableRandomization_Respondent] FOREIGN KEY([RespondentId]) REFERENCES #SURVEY SCHEMA#.[Respondent] ([ResRespondent]) ON DELETE CASCADE,	
	)
END
'

declare @SurveyPayload04 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[VSE_sp_GetRespondentBlockRandomizationPosition]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[VSE_sp_GetRespondentBlockRandomizationPosition]
'

declare @SurveyPayload05 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[VSE_sp_GetRespondentBlockRandomizationPosition]
    @respondentId INT,
    @blockId INT,
	@matrix INT
AS
BEGIN
	SELECT [Position]
    FROM #SURVEY SCHEMA#.[RespondentBlockRandomization]
    WHERE [RespondentId] = @respondentId AND [BlockId] = @blockId AND [Matrix] = @matrix;
END
'

declare @SurveyPayload06 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[VSE_sp_GetRespondentQuestionRandomizationPosition]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[VSE_sp_GetRespondentQuestionRandomizationPosition]
'

declare @SurveyPayload07 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[VSE_sp_GetRespondentQuestionRandomizationPosition]
    @respondentId INT,
    @questionId INT,
	@matrix INT
AS
BEGIN
	SELECT [Position]
    FROM #SURVEY SCHEMA#.[RespondentQuestionRandomization]
    WHERE [RespondentId] = @respondentId AND [QuestionId] = @questionId AND [Matrix] = @matrix;
END
'

declare @SurveyPayload08 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[VSE_sp_UpdateRespondentBlockRandomization]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentBlockRandomization]
'

declare @SurveyPayload09 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentBlockRandomization]
	@respondentId INT,
	@blockId INT,
	@matrix INT,
	@position INT
AS
BEGIN
    UPDATE #SURVEY SCHEMA#.[RespondentBlockRandomization]
    SET [Position] = @position
    WHERE [RespondentId] = @respondentId AND [BlockId] = @blockId AND [Matrix] = @matrix;

    IF @@ROWCOUNT = 0
    BEGIN
	    INSERT INTO #SURVEY SCHEMA#.[RespondentBlockRandomization] ([RespondentId], [BlockId], [Matrix], [Position])
	    VALUES (@respondentId, @blockId, @matrix, @position)
    END
END
'

declare @SurveyPayload10 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[VSE_sp_UpdateRespondentQuestionRandomization]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentQuestionRandomization]
'

declare @SurveyPayload11 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentQuestionRandomization]
	@respondentId INT,
	@matrix INT,
    @questionRandomizations AS [dbo].[RespondentQuestionRandomizationList] READONLY
AS
BEGIN
    UPDATE dest
    SET dest.[Position] = source.[Position]
    FROM #SURVEY SCHEMA#.[RespondentQuestionRandomization] dest
    INNER JOIN @questionRandomizations source
        ON dest.[RespondentId] = @respondentId
        AND dest.[QuestionId] = source.[QuestionId]
        AND dest.[Matrix] = @matrix;

    INSERT INTO #SURVEY SCHEMA#.[RespondentQuestionRandomization] ([RespondentId], [QuestionId], [Matrix], [Position])
    SELECT @respondentId, source.[QuestionId], @matrix, source.[Position]
    FROM @questionRandomizations source
    LEFT JOIN #SURVEY SCHEMA#.[RespondentQuestionRandomization] dest
        ON dest.[RespondentId] = @respondentId
        AND source.[QuestionId] = dest.[QuestionId]
        AND dest.[Matrix] = @matrix
    WHERE dest.[RespondentId] IS NULL;
END
'

declare @SurveyPayload12 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[VSE_sp_UpdateRespondentVariableRandomization]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentVariableRandomization]
'

declare @SurveyPayload13 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[VSE_sp_UpdateRespondentVariableRandomization]
	@respondentId INT,
	@matrix INT,
    @variableRandomizations AS [dbo].[RespondentVariableRandomizationList] READONLY
AS
BEGIN
    UPDATE dest
    SET dest.[Position] = source.[Position]
    FROM #SURVEY SCHEMA#.[RespondentVariableRandomization] dest
    INNER JOIN @variableRandomizations source
        ON dest.[RespondentId] = @respondentId
        AND dest.[VariableName] = source.[VariableName]
        AND dest.[Matrix] = @matrix;

    INSERT INTO #SURVEY SCHEMA#.[RespondentVariableRandomization] ([RespondentId], [VariableName], [Matrix], [Position])
    SELECT @respondentId, source.[VariableName], @matrix, source.[Position]
    FROM @variableRandomizations source
    LEFT JOIN #SURVEY SCHEMA#.[RespondentVariableRandomization] dest
        ON dest.[RespondentId] = @respondentId
        AND source.[VariableName] = dest.[VariableName]
        AND dest.[Matrix] = @matrix
    WHERE dest.[RespondentId] IS NULL;
END
'

declare @SurveyPayload14 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[A4S_sp_GetRespondentsBlockRandomization]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[A4S_sp_GetRespondentsBlockRandomization]
'

declare @SurveyPayload15 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[A4S_sp_GetRespondentsBlockRandomization]
	@respondentIds AS [dbo].[RespondentList] READONLY
AS
BEGIN
	SELECT [RespondentId], [BlockId], [Matrix], [Position]
    FROM #SURVEY SCHEMA#.[RespondentBlockRandomization]
    INNER JOIN @respondentIds ON [RespondentId] = [Id];
END
'

declare @SurveyPayload16 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[A4S_sp_GetRespondentsQuestionRandomization]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[A4S_sp_GetRespondentsQuestionRandomization]
'

declare @SurveyPayload17 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[A4S_sp_GetRespondentsQuestionRandomization]
	@respondentIds AS [dbo].[RespondentList] READONLY
AS
BEGIN
	SELECT [RespondentId], [QuestionId], [Matrix], [Position]
    FROM #SURVEY SCHEMA#.[RespondentQuestionRandomization]
    INNER JOIN @respondentIds ON [RespondentId] = [Id];
END
'

declare @SurveyPayload18 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[A4S_sp_GetRespondentsVariableRandomization]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[A4S_sp_GetRespondentsVariableRandomization]
'

declare @SurveyPayload19 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[A4S_sp_GetRespondentsVariableRandomization]
	@respondentIds AS [dbo].[RespondentList] READONLY
AS
BEGIN
	SELECT [RespondentId], [VariableName], [Matrix], [Position]
    FROM #SURVEY SCHEMA#.[RespondentVariableRandomization]
    INNER JOIN @respondentIds ON [RespondentId] = [Id];
END
'

declare @SurveyPayload20 nvarchar(max) = N'
IF EXISTS (SELECT 1 FROM sys.objects WHERE object_id = OBJECT_ID(N''#SURVEY SCHEMA#.[A4S_sp_GetAllRandomizedElements]'') AND schema_Id <> SCHEMA_ID(''dbo'') AND type in (N''P'', N''PC''))
   DROP PROCEDURE #SURVEY SCHEMA#.[A4S_sp_GetAllRandomizedElements]
'

declare @SurveyPayload21 nvarchar(max) = N'
CREATE PROCEDURE #SURVEY SCHEMA#.[A4S_sp_GetAllRandomizedElements]
AS
BEGIN
	SELECT DISTINCT [VariableName] FROM #SURVEY SCHEMA#.[RespondentVariableDisplayOrder]
	SELECT DISTINCT [VariableName] FROM #SURVEY SCHEMA#.[RespondentChoiceDisplayOrder]
	SELECT DISTINCT [BlockId] FROM #SURVEY SCHEMA#.[RespondentBlockRandomization]
	SELECT DISTINCT [QuestionId] FROM #SURVEY SCHEMA#.[RespondentQuestionRandomization]
	SELECT DISTINCT [VariableName] FROM #SURVEY SCHEMA#.[RespondentVariableRandomization]
END
'

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait

        print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 2'
		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 3'
		select @SQL = replace(replace(@ClientPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 4'
		select @SQL = replace(replace(@ClientPayload04, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 5'
		select @SQL = replace(replace(@ClientPayload05, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 6'
		select @SQL = replace(replace(@ClientPayload06, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 7'
		select @SQL = replace(replace(@ClientPayload07, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 8'
		select @SQL = replace(replace(@ClientPayload08, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 9'
		select @SQL = replace(replace(@ClientPayload09, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 10'
		select @SQL = replace(replace(@ClientPayload10, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 11'
		select @SQL = replace(replace(@ClientPayload11, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 12'
		select @SQL = replace(replace(@ClientPayload12, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 13'
		select @SQL = replace(replace(@ClientPayload13, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 14'
		select @SQL = replace(replace(@ClientPayload14, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 15'
		select @SQL = replace(replace(@ClientPayload15, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 16'
		select @SQL = replace(replace(@ClientPayload16, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 17'
		select @SQL = replace(replace(@ClientPayload17, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

        print 'Client Payload 18'
		select @SQL = replace(replace(@ClientPayload18, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Payload done!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end

	select @TotalSurveys = count(*) from #Survey
	set @SurveyCursor = cursor forward_only for select DBName, SchemaName from #Survey for update of Processed
	open @SurveyCursor
	fetch next from @SurveyCursor into @ThisClient, @ThisSurvey
	while @@FETCH_STATUS = 0 begin
		select @SurveyCounter += 1
		select @StatusMessage = 'Updating survey "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @SurveyCounter / @TotalSurveys
		raiserror (@StatusMessage, 0, 1, @ThisSurvey, @SurveyCounter, @TotalSurveys, @StatusPercent) with nowait

		declare @SurveyExists bit = 0;
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'

		select @SQL = N'SELECT @SurveyExistsOutput = 1; if exists (select * from ' + @ThisClient + '.sys.schemas where [name] = ''' + @ThisSurvey + ''') SELECT @SurveyExistsOutput = 1 '
		exec sp_executesql @SQL, N'@SurveyExistsOutput bit out', @SurveyExists out
		--select @SurveyExists

		if @SurveyExists = 1
		BEGIN 
		   print 'Survey Payload 1'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 2'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 3'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 4'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload04, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 5'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload05, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 6'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload06, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 7'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload07, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 8'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload08, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 9'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload09, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 10'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload10, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 11'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload11, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 12'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload12, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 13'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload13, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 14'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload14, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 15'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload15, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 16'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload16, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 17'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload17, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 18'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload18, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 19'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload19, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 20'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload20, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'Survey Payload 21'
		   SELECT @SQL = replace(replace(replace(@SurveyPayload21, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient), '#SURVEY SCHEMA#', @ThisSurvey)
		   IF isnull(@SQL, '') <> '' exec @DBSQL @SQL

		   print 'All Survey Payload done!'

        END
        ELSE 
		BEGIN
		   print '  >>>>> Survey has been deleted!'
		END

		update #Survey set Processed = 1 where current of @SurveyCursor
		fetch next from @SurveyCursor into @ThisClient, @ThisSurvey
	end

	truncate table #SurveyVerif
	fetch first from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #SurveyVerif select ''' + @ThisClient + ''', SchemaName from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName from #SurveysDone'
		exec @DBSQL @SQL
		fetch next from @ClientCursor into @ThisClient
	end

	close @ClientCursor
	close @SurveyCursor
	deallocate @ClientCursor
	deallocate @SurveyCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

	IF exists (select DBName, SchemaName from #SurveyVerif except select DBName, SchemaName from #Survey where Processed = 1) 
	BEGIN
		raiserror ('  >>>>> New survey(s) have been added or were skipped, going again!', 0, 1)
		insert into #SurveysDone select DBName, SchemaName from #Survey where Processed = 1
		truncate table #DB
		truncate table #Survey
	END 
	ELSE 
    BEGIN
	  SELECT @AllDone = 1
    END

end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone